"use strict";
/**
 * This module is a thin wrapper over the shared libraries used to manage the process scanning service and communicate with it.
 *
 * @module @wontok/node-addon-process-scanning
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.initLib = void 0;
//#region Imports
var electron_1 = require("electron");
var init_for_electron_main_1 = require("./init-for-electron-main");
var init_for_node_1 = require("./init-for-node");
var utils_1 = require("./utils");
//#endregion
var initLib = function (publicOptions) {
    if (electron_1.ipcMain) {
        utils_1.debug("Init for electron main\n");
        return init_for_electron_main_1.initForElectronMain(publicOptions);
    }
    else if (electron_1.ipcRenderer) {
        // 3. I'm not sending any process scanning information to the renderer.
        utils_1.debug("Init for electron renderer\n");
        throw new Error("Process Scanning lib has no renderer implementation yet.");
    }
    else {
        utils_1.debug("Init for node\n");
        return init_for_node_1.initForNode(publicOptions);
    }
};
exports.initLib = initLib;
